===================================================================================
 WorldnetPayments Payment Gateway for Magento 2.x module V1.7.3 28-02-2022
===================================================================================
Contributors: WorldnetPayments
Link: https://www.worldnetpayments.com/
Tags: payment
Tested up to: 2.4.3-p1
Stable tag: 1.7.3
License: GPLv3 or later
License URI: http://www.gnu.org/licenses/gpl-3.0.html


================================ Installation ====================================

This module has to be installed after the Magento installation process.

The installation requires composer usage. Add the following in your magento_root/composer.json

    "repositories": [
        {
            "type": "path",
            "url": "./tmp/worldnetpayments/"
        },
        {
            "type": "path",
            "url": "./tmp/worldnetpayments/module-payment/"
        },
        {
            "type": "path",
            "url": "./tmp/worldnetpayments/module-secure-card/"
        },
        {
            "type": "path",
            "url": "./tmp/worldnetpayments/module-subscription/"
        }
    ]

Copy the worldnetpayments folder inside the `magento_root/tmp/` location. This can be different, but make sure you update the above paths as well.

In case of ApplePay integration, after following the steps in chapter 8 of the plugin's features manual, 
copy the applemid.key and applemid.pem files inside the 
`magento_root/tmp/worldnetpayments/module-payment/Controller/Directpost/Payment/certificates` 
folder, replacing the placeholder ones.

Run the following command in your CLI:
    
    composer require worldnetpayments/payment-gateway

It's important to follow Magento's guidelines on ownership and permissions 
https://devdocs.magento.com/guides/v2.4/install-gde/prereq/file-sys-perms-over.html
Once you have an environment user added to your system, make sure it is assigned to the www-data group or the correspondent
one on your operating system. 

    #for Unix systems
    sudo usermod -aG www-data your_magento_user
    sudo chown -R your_magento_user:www-data ./

    #for Windows - Apache
    net localgroup www-data your_magento_user /add    
    icacls magento_root /setowner your_magento_user /T /C /L    
    icacls magento_root /grant  your_magento_user:F /T /C 
    icacls magento_root /grant  www-data:F /T /C 

    #for Windows - IIS
    net localgroup IIS_IUSRS your_magento_user /add    
    icacls magento_root /setowner your_magento_user /T /C /L    
    icacls magento_root /grant  your_magento_user:F /T /C 
    icacls magento_root /grant  IIS_IUSRS:F /T /C 

Logged in as your_magento_user, upgrade and recompile magento, deploy static content and clean the cache using the following commands:

    php bin/magento setup:upgrade
    php bin/magento setup:di:compile 
    php bin/magento setup:static-content:deploy -f
    php bin/magento cache:clean
    
You will then need to go to the admin section of your Magento installation:

1) Magento Admin -> Stores -> Configuration -> Sales -> Payment Methods
2) You should then see "WorldnetPayments Payment Gateway" appear as a payment method (if not see below). 
3) Click on this and select Enabled = "Yes".
4) Enter the Gateway, Currency, Terminal ID and your "Shared Secret". (These details were supplied by WorldnetPayments.)
5) Click "Save Config" in the top right corner.


====================== How to Perform Refund =======================================
To perform a refund on a transaction,
Go to: Magento Admin->Sales->Invoices->View->Credit Memo...->Refund


=========================== TroubleShooting =========================================
If the module does not appear on the "Payment Methods" page you may have to clear/refresh Magento's cache.
To do this go to System -> Cache Management and click the "Flush Magento Cache" button on the top right.

============================= CHANGELOG =============================================

-----------------------------------------------------------------------------
V1.7 - Payment module updated as part of Magento Payment Gateway 1.1.0 release
     - Payment flow changed, a Magento order is created only after successful payment

-----------------------------------------------------------------------------
V1.6 - The payment gateway can now be installed with Composer as well.

-----------------------------------------------------------------------------
V1.5 - $_GET and $_POST replaced with getRequest methods

-----------------------------------------------------------------------------
V1.4 - SecureCard implemented
     - Subscription functionality available

-----------------------------------------------------------------------------
V1.3 - Phase 1 of a new plugin version developed and tested with
       Magento 2.1.8
     - Plugin supports both HPP and XML payments, Void & Refund, AVS & CVV validation, 
       Threat Metrix integration, custom fields integration.
     - Unlike V1.2, the payment gateway is branded for different clients.

-----------------------------------------------------------------------------
V1.2 - Added Payzone,GlobalOnePay,AnywhereCommerce,CT Payments,PayConex Plus,
       CashFlows.
       Added Swedish Krona, Danish Krone,Australian Dollar,Canadian Dollar 
       as currency options.
       
-----------------------------------------------------------------------------
V1.1 - Added config option to use either Store Base currency or Cart Display
       Currency as the checkout currency.
     - Disabled refunds if using the Cart Display Currency as they went in
       the base currency (wrong amount).

-----------------------------------------------------------------------------
V1.0 - Tested Magento 1.4 HPP plug-in version 1.7 in Magento 1.6.2 successfully

-----------------------------------------------------------------------------
============================= Contact Email ==============================================
For any Further Queries or Doubts Please contact us via below e-mail
Email -: support@worldnettps.com

==========================================================================================

