<?php
/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace WorldnetPayments\Payment\Model\Directpost;

use WorldnetPayments\Payment\Model\Response as WorldnetPaymentsResponse;
use Magento\Framework\Encryption\Helper\Security;

/**
 * WorldnetPayments TPS response model for DirectPost model
 */
class Response extends WorldnetPaymentsResponse
{
    /**
     * Return if this is approved response from WorldnetPayments TPS auth request.
     *
     * @return bool
     */
    public function isApproved()
    {
        return $this->getXResponseCode() == \WorldnetPayments\Payment\Model\Directpost::RESPONSE_CODE_APPROVED;
    }
}
