<?php
/**
 * Copyright © 2013-2017 Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace WorldnetPayments\Payment\Controller\Directpost\Payment;

use WorldnetPayments\Payment\Controller\Directpost\Payment;
use WorldnetPayments\Payment\Helper\DataFactory;
use Magento\Checkout\Model\Type\Onepage;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Response\Http;
use Magento\Framework\Json\Helper\Data as JsonHelper;
use Magento\Framework\DataObject;
use Magento\Framework\Registry;
use WorldnetPayments\Payment\Model\IframeConfigProvider;
use Magento\Quote\Api\CartManagementInterface;

/**
 * Class ApplePaySession
 *
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class ApplePaySession extends Payment
{

    /** @var \Magento\Framework\Controller\Result\JsonFactory */
    protected $jsonResultFactory;

    /**
     * Core store config
     *
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $_scopeConfig;

    /**
     * Retrieve information from payment configuration
     *
     * @param string $field
     * @param int|string|null|\Magento\Store\Model\Store $storeId
     *
     * @return mixed
     */
    public function getConfigData($field)
    {
        $path = 'payment/worldnetpayments_directpost/' . $field;
        return $this->_scopeConfig->getValue($path, \Magento\Store\Model\ScopeInterface::SCOPE_WEBSITES);
    }

    public function getField($field) {
        if ($this->getConfigData('mode') == 'LIVE')
            return  ($this->getConfigData($field));
        else
            return  ($this->getConfigData('test_'.$field));
    }

    /**
     * @param Context $context
     * @param Registry $coreRegistry
     * @param DataFactory $dataFactory
     * @param JsonHelper $jsonHelper
     */
    public function __construct(
        Context $context,
        Registry $coreRegistry,
        DataFactory $dataFactory,
        \Magento\Framework\Controller\Result\JsonFactory $jsonResultFactory,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    ) {
        $this->jsonResultFactory = $jsonResultFactory;
        $this->_scopeConfig = $scopeConfig;
        parent::__construct($context, $coreRegistry, $dataFactory);
    }

    /**
     * Send request to WorldnetPayments
     *
     * @return string
     */
    public function execute()
    {
        $validationURL = $this->getRequest()->getPost('validationURL')?:"https://apple-pay-gateway-cert.apple.com/paymentservices/startSession";
        $response = $this->jsonResultFactory->create();

        $soap = curl_init();

        $data_string = json_encode([
            "merchantIdentifier" => $this->getField('applepay_merchant_identifier'),
            "displayName"=> $this->getField('applepay_display_name'),
            "initiative"=> "web",
            "initiativeContext"=> $this->getField('applepay_initiative_context')
        ]);

        curl_setopt($soap, CURLOPT_URL, $validationURL);
        curl_setopt($soap, CURLOPT_SSLCERTTYPE,"PEM");
        curl_setopt($soap, CURLOPT_SSLCERT ,  __DIR__ . "/certificates/applemid.pem");
        curl_setopt($soap, CURLOPT_SSLKEY ,  __DIR__ . "/certificates/applemid.key");
        curl_setopt($soap, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($soap, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($soap, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($soap, CURLOPT_TIMEOUT,        15);
        curl_setopt($soap, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($soap, CURLOPT_POST,           true);
        curl_setopt($soap, CURLOPT_POSTFIELDS,     $data_string);
        curl_setopt($soap, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($data_string))
        );

        $result = curl_exec($soap);

        if (curl_errno($soap) > 0) {
            $result = array('errocurl' => curl_errno($soap), 'msgcurl' => curl_error($soap));
        }

        curl_close($soap);

        $response->setData($result);

        return $response;
    }
}
